   ; DeScaler: undoes the results of Scaler.lsp (within certain limits).
   ; Copyright 1991 Rocket Software
   ; Caution: Do not attempt to use this program on dead fish.
  (DEFUN C:DESCALE (/ ok ss gr sn)
   (setvar "cmdecho" 1)
   (setq ok t)
   (setq dim (getvar "dimscale"))
   (if (= dim 1.0)
   (progn
   (write-line "Dimscale is set to 1.0 - Drawing may not have been scaled.")
   (setq dim (getreal "Assumed scale factor to use? (<Return> to cancel): "))))
   (if dim
   (progn
   (setq ss (/ 1 dim))

;**************** set variables ****************

   (setvar "dimscale" 1.0)
   (setvar "filletrad" 2.0)
   (setvar "ltscale" 8.0)
   (setvar "textsize" 2.5)
   (setvar "snapunit" (list 1 1))
   (setq gr 10)
   (setvar "gridunit" (list gr gr))

;***************** scale drawing ****************

   (command ".zoom" "a")
   (command ".scale" "c" (getvar "extmin") (getvar "extmax")
                     "" (getvar "extmin") ss)
;***************** reset limits *****************
   (command ".zoom" "e")
   (setq maxx (getvar "extmax"))
   (setq minn (getvar "extmin"))
   (if (= (length maxx) 3)
       (progn                                    ; if limmax has 3 numbers:
             (setvar "limmax" (reverse (cdr (reverse maxx))))
             (setvar "limmin" (reverse (cdr (reverse minn))))) ; progn end
       (progn                                    ; alternately, if it doesn't:
             (setvar "limmax" maxx)
             (setvar "limmin" minn)))             ; progend, ifend

;******************** and end ********************

   (setq ss (rtos ss))
   (setq oc ())
   (while (and (or (= (substr ss (strlen ss)) "0")
                   (= (substr ss (strlen ss)) "."))
               (= oc ()))
               (progn
                     (if (=  (substr ss (strlen ss)) ".") (setq oc t))
                     (setq ss (substr ss 1 (- (strlen ss) 1)))))
   (write-line (strcat "Descale factor used: " ss))
   )(write-line "*Cancelled*"))
   (PRINC))